<?php

// include configuration file
include('config.php');
	
// connect to the database
$dbc = @mysqli_connect ($db_host, $db_user, $db_password, $db_name) OR die ('Could not connect to MySQL: ' . mysqli_connect_error());

// continue session
session_start();

// if the submit button has been pressed
if(isset($_POST['submit']))
{
	// create an empty error array
	$error = array();
	
	// check for a email
	if(empty($_POST['email']))
	{
		$error['email'] = 'Required field';
	} 
	
	// check for a password
	if(empty($_POST['userpass']))
	{
		$error['userpass'] = 'Required field';
	} 
	
	// check signin credentials
	if(!empty($_POST['email']) && !empty($_POST['userpass']))
	{
		// get user_id from the users table
		$query = "SELECT 
					user_id, 
					firstname, 
					lastname 
				FROM 
					users 
				WHERE 
					email = '{$_POST['email']}' AND userpass = sha1('{$_POST['userpass']}') 
				LIMIT 1";
		$result = mysqli_query($dbc, $query);
		$row = mysqli_fetch_assoc($result);
		
		// if the user is not found
		if(!$row['user_id'])
		{
			$error['user'] = 'Invalid username and/or password';
		}
	}
	
	// if there are no errors
	if(sizeof($error) == 0)
	{
		// append user_id to session
		$_SESSION['user_id'] = $row['user_id'];
		$_SESSION['firstname'] = $row['firstname'];
		$_SESSION['lastname'] = $row['lastname'];
		
		// redirect user to profile page
		header("Location: etsmailer.php");
		exit();

	} 
}

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="shortcut icon" href="../../docs-assets/ico/favicon.png">

    <title>Signin Template for Bootstrap</title>

    <!-- Bootstrap core CSS -->
    <link href="./dist/css/bootstrap.css" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="signin.css" rel="stylesheet">

    <!-- Just for debugging purposes. Don't actually copy this line! -->
    <!--[if lt IE 9]><script src="../../docs-assets/js/ie8-responsive-file-warning.js"></script><![endif]-->

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->
    <style>
    body{
	    padding-top: 80px;
    }
    </style>
  </head>

  <body>
  
      <div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
      <div class="container">
        <div class="navbar-header">
          <a class="navbar-brand" href="#">ETS Private Site</a>
        </div>
      </div>
    </div>

    <div class="container-fluid">
    <div class="container">

		<div class="col-md-4 col-md-offset-4">
	<form method="post" action="index.php">
        <h2 class="form-signin-heading">Please sign in</h2>
		<?php
			// check for a user error
			if($error['user'])
			{
				echo "<div class=\"alert alert-error\">{$error['user']}</div>";
			}
		?>
        <input type="text" class="form-control" placeholder="Email address" name="email" value="<?php echo $_POST['email']; ?>" autocomplete="off" required autofocus>
		<span class="text-error"><?php echo $error['email']; ?></span>
		
        <input type="password" class="form-control" placeholder="Password" id="password" name="userpass" autocomplete="off" required>
		<span class="text-error"><?php echo $error['userpass']; ?></span><br />

		<input name="submit" type="submit" value="Sign in" class="btn btn-large btn-primary" />
      </form>
		</div>
    </div>
    </div> <!-- /container -->


    <!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
  </body>
</html>